/*

EditPatch Operations MacroScript File

Revision history:

		June 12 2000: Frank DeLise
			3ds max 4
	
		10 Juin 2003: Pierre-Felix Breton
			3ds max 6
	
		12 dec 2003, Pierre-Felix Breton, 
			added product switcher: this macroscript file can be shared with all Discreet products


EditPatch operations Macroscript file.

*/
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
-- 
-- Renamed Flt_EditPath --> Filters.Is_EditPatch

MacroScript EPatch_Attach
ButtonText:~EPATCH_ATTACH_BUTTONTEXT~
Category:~EPATCH_ATTACH_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_ATTACH_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		Try(ApplyOperation Edit_Patch Patchops.startAttach)Catch()
	
	)

)

MacroScript EPatch_Detach_Element
ButtonText:~EPATCH_DETACH_ELEMENT_BUTTONTEXT~
Category:~EPATCH_DETACH_ELEMENT_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_DETACH_ELEMENT_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 3 then subobjectlevel = 3
		Try(ApplyOperation Edit_Patch PatchOps.Detach)Catch()
	
	)

)
MacroScript EPatch_Detach_Patch
ButtonText:~EPATCH_DETACH_PATCH_BUTTONTEXT~
Category:~EPATCH_DETACH_PATCH_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_DETACH_PATCH_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 4 then subobjectlevel = 4
		Try(ApplyOperation Edit_Patch PatchOps.Detach)Catch()
	
	)

)
MacroScript EPatch_Extrude_Edge
ButtonText:~EPATCH_EXTRUDE_EDGE_BUTTONTEXT~
Category:~EPATCH_EXTRUDE_EDGE_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_EXTRUDE_EDGE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 2 then subobjectlevel = 2
		Try(ApplyOperation Edit_Patch PatchOps.StartExtrude)Catch()
	
	)

)
MacroScript EPatch_Extrude_Patch
ButtonText:~EPATCH_EXTRUDE_PATCH_BUTTONTEXT~
Category:~EPATCH_EXTRUDE_PATCH_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_EXTRUDE_PATCH_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 3 then subobjectlevel = 3
		Try(ApplyOperation Edit_Patch PatchOps.StartExtrude)Catch()
	
	)

)
MacroScript EPatch_Extrude_Element
ButtonText:~EPATCH_EXTRUDE_ELEMENT_BUTTONTEXT~
Category:~EPATCH_EXTRUDE_ELEMENT_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_EXTRUDE_ELEMENT_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 4 then subobjectlevel = 4
		Try(ApplyOperation Edit_Patch PatchOps.StartExtrude)Catch()
	
	)

)
MacroScript EPatch_Bind
ButtonText:~EPATCH_BIND_BUTTONTEXT~
Category:~EPATCH_BIND_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_BIND_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 1 then subobjectlevel = 1
		Try(ApplyOperation Edit_Patch PatchOps.StartBind)Catch()
	
	)

)
MacroScript EPatch_UnBind
ButtonText:~EPATCH_UNBIND_BUTTONTEXT~
Category:~EPATCH_UNBIND_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_UNBIND_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel == 1 then Try(ApplyOperation Edit_Patch PatchOps.UnBind)Catch()
		else subobjectlevel = 1
	)

)
MacroScript EPatch_Weld
ButtonText:~EPATCH_WELD_BUTTONTEXT~
Category:~EPATCH_WELD_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_WELD_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 2 then subobjectlevel = 2
		Try(ApplyOperation Edit_Patch PatchOps.Weld)Catch()
	
	)

)
MacroScript EPatch_Add_Tri
ButtonText:~EPATCH_ADD_TRI_BUTTONTEXT~
Category:~EPATCH_ADD_TRI_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_ADD_TRI_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 2 then subobjectlevel = 2
		Try(ApplyOperation Edit_Patch PatchOps.AddTri)Catch()
	
	)

)

MacroScript EPatch_Add_Quad
ButtonText:~EPATCH_ADD_QUAD_BUTTONTEXT~
Category:~EPATCH_ADD_QUAD_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_ADD_QUAD_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 2 then subobjectlevel = 2
		Try(ApplyOperation Edit_Patch PatchOps.AddQuad)Catch()
	
	)

)

MacroScript EPatch_Hide
ButtonText:~EPATCH_HIDE_BUTTONTEXT~
Category:~EPATCH_HIDE_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_HIDE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatchSpecifyLevel #{2..5}

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 3 then subobjectlevel = 3
		else Try(ApplyOperation Edit_Patch PatchOps.Hide)Catch()
	
	)

)

MacroScript EPatch_UnHide
ButtonText:~EPATCH_UNHIDE_BUTTONTEXT~
Category:~EPATCH_UNHIDE_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_UNHIDE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatchSpecifyLevel #{2..5}

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel == undefined then subobjectlevel = 1
		Try(ApplyOperation Edit_Patch PatchOps.UnHideAll)Catch()
	
	)

)

MacroScript EPatch_Bevel_Patch
ButtonText:~EPATCH_BEVEL_PATCH_BUTTONTEXT~
Category:~EPATCH_BEVEL_PATCH_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_BEVEL_PATCH_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 3 then subobjectlevel = 3
		Try(ApplyOperation Edit_Patch PatchOps.StartBevel)Catch()
	
	)

)
MacroScript EPatch_Bevel_Element
ButtonText:~EPATCH_BEVEL_ELEMENT_BUTTONTEXT~
Category:~EPATCH_BEVEL_ELEMENT_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_BEVEL_ELEMENT_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 4 then subobjectlevel = 4
		Try(ApplyOperation Edit_Patch PatchOps.StartBevel)Catch()
	
	)

)

MacroScript EPatch_Delete_Vertex
ButtonText:~EPATCH_DELETE_VERTEX_BUTTONTEXT~
Category:~EPATCH_DELETE_VERTEX_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_DELETE_VERTEX_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 1 then subobjectlevel = 1
		Try(ApplyOperation Edit_Patch PatchOps.Delete)Catch()
	
	)

)

MacroScript EPatch_Delete_Edge
ButtonText:~EPATCH_DELETE_EDGE_BUTTONTEXT~
Category:~EPATCH_DELETE_EDGE_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_DELETE_EDGE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 2 then subobjectlevel = 2
		Try(ApplyOperation Edit_Patch PatchOps.Delete)Catch()
	
	)

)


MacroScript EPatch_Delete_Patch
ButtonText:~EPATCH_DELETE_PATCH_BUTTONTEXT~
Category:~EPATCH_DELETE_PATCH_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_DELETE_PATCH_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 3 then subobjectlevel = 3
		Try(ApplyOperation Edit_Patch PatchOps.Delete)Catch()
	
	)

)

MacroScript EPatch_Delete_Element
ButtonText:~EPATCH_DELETE_ELEMENT_BUTTONTEXT~
Category:~EPATCH_DELETE_ELEMENT_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_DELETE_ELEMENT_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 4 then subobjectlevel = 4
		Try(ApplyOperation Edit_Patch PatchOps.Delete)Catch()
	
	)

)

MacroScript EPatch_Subdivide_Edge
ButtonText:~EPATCH_SUBDIVIDE_EDGE_BUTTONTEXT~
Category:~EPATCH_SUBDIVIDE_EDGE_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_SUBDIVIDE_EDGE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel == 2 then Try(ApplyOperation Edit_Patch PatchOps.Subdivide)Catch()
		else subobjectlevel = 2
	
	)

)

MacroScript EPatch_Subdivide_Patch
ButtonText:~EPATCH_SUBDIVIDE_PATCH_BUTTONTEXT~
Category:~EPATCH_SUBDIVIDE_PATCH_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_SUBDIVIDE_PATCH_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel == 3 or subobjectlevel == 4 then Try(ApplyOperation Edit_Patch PatchOps.Subdivide)Catch()
		else subobjectlevel = 3
	)

)
MacroScript EPatch_Subdivide_Element
ButtonText:~EPATCH_SUBDIVIDE_ELEMENT_BUTTONTEXT~
Category:~EPATCH_SUBDIVIDE_ELEMENT_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_SUBDIVIDE_ELEMENT_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel == 4 then Try(ApplyOperation Edit_Patch PatchOps.Subdivide)Catch()
		else subobjectlevel = 4
	)

)
-- Last Updated: 	Sept 5 2000
--
-- Author :   Fred Ruff
-- Version:  3ds max 4
--
-- 
-- EditPatch operations Macroscript updates.
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

MacroScript EPatch_CreatePatch
ButtonText:~EPATCH_CREATEPATCH_BUTTONTEXT~
Category:~EPATCH_CREATEPATCH_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_CREATEPATCH_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 3 then subobjectlevel = 3
		Try(ApplyOperation Edit_Patch PatchOps.startcreate)Catch()
	)
)
MacroScript EPatch_TargetWeld
ButtonText:~EPATCH_TARGETWELD_BUTTONTEXT~
Category:~EPATCH_TARGETWELD_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_TARGETWELD_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 1 then subobjectlevel = 1
		Try(ApplyOperation Edit_Patch PatchOps.StartWeldtarget)Catch()
	)
)
MacroScript EPatch_FlipNormalMode
ButtonText:~EPATCH_FLIPNORMALMODE_BUTTONTEXT~
Category:~EPATCH_FLIPNORMALMODE_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_FLIPNORMALMODE_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 3 then subobjectlevel = 3
		Try(ApplyOperation Edit_Patch PatchOps.StartFlipNormalMode)Catch()
	)
)
MacroScript EPatch_SelectOpenEdges
ButtonText:~EPATCH_SELECTOPENEDGES_BUTTONTEXT~
Category:~EPATCH_SELECTOPENEDGES_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_SELECTOPENEDGES_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 2 then subobjectlevel = 2
		Try(ApplyOperation Edit_Patch PatchOps.SelectOpenEdges)Catch()
	)
)
MacroScript EPatch_BreakVertex
ButtonText:~EPATCH_BREAKVERTEX_BUTTONTEXT~
Category:~EPATCH_BREAKVERTEX_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_BREAKVERTEX_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel == 1  then Try(ApplyOperation Edit_Patch PatchOps.Break)Catch()
		else subobjectlevel = 1
	)
)
MacroScript EPatch_CreateShapeFromEdges
ButtonText:~EPATCH_CREATESHAPEFROMEDGES_BUTTONTEXT~
Category:~EPATCH_CREATESHAPEFROMEDGES_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_CREATESHAPEFROMEDGES_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 2 then subobjectlevel = 2
		Try(ApplyOperation Edit_Patch PatchOps.CreateShapeFromEdges)Catch()
	)
)
MacroScript EPatch_FlipNormal
ButtonText:~EPATCH_FLIPNORMAL_BUTTONTEXT~
Category:~EPATCH_FLIPNORMAL_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_FLIPNORMAL_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 4 then subobjectlevel = 4
		Try(ApplyOperation Edit_Patch PatchOps.FlipNormal)Catch()
	)
)
MacroScript EPatch_UnifyNormal
ButtonText:~EPATCH_UNIFYNORMAL_BUTTONTEXT~
Category:~EPATCH_UNIFYNORMAL_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_UNIFYNORMAL_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 4 then subobjectlevel = 4
		Try(ApplyOperation Edit_Patch PatchOps.UnifyNormal)Catch()
	)
)
MacroScript EPatch_SelectByMatID
ButtonText:~EPATCH_SELECTBYMATID_BUTTONTEXT~
Category:~EPATCH_SELECTBYMATID_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_SELECTBYMATID_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 4 then subobjectlevel = 4
		Try(ApplyOperation Edit_Patch PatchOps.SelectByMatID)Catch()
	)
)
MacroScript EPatch_SelectBySG
ButtonText:~EPATCH_SELECTBYSG_BUTTONTEXT~
Category:~EPATCH_SELECTBYSG_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_SELECTBYSG_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 4 then subobjectlevel = 4
		Try(ApplyOperation Edit_Patch PatchOps.SelectBySG)Catch()
	)
)
MacroScript EPatch_ClearAllSG
ButtonText:~EPATCH_CLEARALLSG_BUTTONTEXT~
Category:~EPATCH_CLEARALLSG_CATEGORY~ 
internalCategory:"Editable Patch Object" 
Tooltip:~EPATCH_CLEARALLSG_TOOLTIP~ 
-- Needs Icon
(
	--On IsEnabled Return Filters.Is_EditPatch()
	On IsVisible Return Filters.Is_EditPatch()

	On Execute Do
	(
		if subobjectlevel == undefined then max modify mode
		if subobjectlevel != 4 then subobjectlevel = 4
		Try(ApplyOperation Edit_Patch PatchOps.ClearAllSG)Catch()
	)
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBrQ24goyYwIsBvasNeiBWeO6TAs8WRSqAF
-- EQ3WJSO6pfQicK7eX2DCGDX94NWTpM2SWJBT0p3dyPIRY+ODjLHiwnMeSkZyebmQ
-- I8DWCMkbaKbXNW/ME/+VLRIfgBikL5lDN34+djNFvaRE2qYMbrvrVluyA7F+FXWQ
-- nVF4bIeJiojkR+7r5C8j2NmaOu+8PTi2U+r7Cc1TuHdhvP7tISKOtNt010cIsedr
-- zwpbd5WkR0rxpz6QzOzPXv0ByHLhgiibOv6teKs3V7my1o1Bn6BAVN9xLubV8zYg
-- IQRvXpc/RYPx2gm+IXDFC5eyYIgD8oPWXTgVN2hVlpe37D3reOW+
-- -----END-SIGNATURE-----